//	ENB Series v 0.16x
//	K ENB ber 

//++++++++++++++++++++++++++++++++++++
//internal parameters, can be modified
//++++++++++++++++++++++++++++++++++++
//float	ELenzIntensity=0.665;	//0.675; //[KYO : Overboard]
float	ELenzIntensity=0.625;	//[KYO : Alpha II]
//float	ELenzIntensity=0.365;	//[KYO : less intrusive]		
//float	ELenzIntensity=0.465; 	//0.725; //[KYO : Alternative Sun]
//float	ELenzIntensity=0.425;	//[KYO : Alpha]
//float	ELenzIntensity=1.525;	//[KYO : MIS]

//++++++++++++++++++++++++++++++++++
//external parameters, do not modify
//++++++++++++++++++++++++++++++++++
//keyboard controlled temporary variables (in some versions exists in the config file). Press and hold key 1,2,3...8 together with PageUp or PageDown to modify. By default all set to 1.0
float4	tempF1; //0,1,2,3
float4	tempF2; //5,6,7,8
float4	tempF3; //9,0
//x=Width, y=1/Width, z=ScreenScaleY, w=1/ScreenScaleY
float4	ScreenSize;
//x=generic timer in range 0..1, period of 16777216 ms (4.6 hours), w=frame time elapsed (in seconds)
float4	Timer;
//xy=sun position on screen, w=visibility
float4	LightParameters;

//textures
texture2D texColor;
texture2D texMask;

sampler2D SamplerColor = sampler_state
{
	Texture   = <texColor>;
	MinFilter = LINEAR;
	MagFilter = LINEAR;
	MipFilter = NONE;
	AddressU  = Clamp;
	AddressV  = Clamp;
	SRGBTexture=FALSE;
	MaxMipLevel=0;
	MipMapLodBias=0;
};

sampler2D SamplerMask = sampler_state
{
	Texture   = <texMask>;
	MinFilter = LINEAR;
	MagFilter = LINEAR;
	MipFilter = NONE;
	AddressU  = Clamp;
	AddressV  = Clamp;
	SRGBTexture=FALSE;
	MaxMipLevel=0;
	MipMapLodBias=0;
};

struct VS_OUTPUT_POST
{
	float4 vpos  : POSITION;
	float2 txcoord : TEXCOORD0;
};

struct VS_INPUT_POST
{
	float3 pos  : POSITION;
	float2 txcoord : TEXCOORD0;
};

/**
 * Pseudo-random number generator - returns a number generated according to the provided vector.
 */
float Random(float2 co)
{
    return frac(sin(dot(co.xy, float2(12.9898, 78.233))) * 43758.5453);
}

//Several sprites moving similar to lenz effect,
//They are transformed in vertex shader and drawed separately for
//better performance. Offset is set in passes of technique
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
VS_OUTPUT_POST VS_Draw(VS_INPUT_POST IN, uniform float offset, uniform float scale)
{
	VS_OUTPUT_POST OUT;

	float4 pos=float4(IN.pos.x,IN.pos.y,IN.pos.z,1.0);
	pos.y*=ScreenSize.z;

	//create own parameters instead of this, including uv offsets
	float2 shift=LightParameters.xy * offset;
	pos.xy=pos.xy * scale - shift;

	OUT.vpos=pos;
	OUT.txcoord.xy=IN.txcoord.xy;

	return OUT;
}

float4 PS_Draw(VS_OUTPUT_POST IN, float2 vPos : VPOS) : COLOR
{
	float4 res;
	float2 coord=IN.txcoord.xy;

	//read sun visibility as amount of effect
	float sunmask=tex2D(SamplerMask, float2(0.5, 0.5)).x;
	sunmask=pow(sunmask, 1.2);//more contrast to clouds
	clip(sunmask-0.02);//early exit if too low

	float4 origcolor=tex2D(SamplerColor, coord.xy);
	sunmask*=LightParameters.w * ELenzIntensity;
	res.xyz=origcolor * sunmask;

	float clipper=dot(res.xyz, 0.333);
	clip(clipper-0.0003);//skip draw if black

	res.w=1.0;
	return res;
}

VS_OUTPUT_POST VS_Draw2(VS_INPUT_POST IN, uniform float scale)
{
	VS_OUTPUT_POST OUT;

	float4 pos = float4(IN.pos.x,IN.pos.y,IN.pos.z,1.0);
	pos.y *= ScreenSize.z;
	
	float l = length(LightParameters.xy);
	float scaleFactor = (2.0 - 1.0 / (l * l + 1.0)) * scale;
	float2 shift = LightParameters.xy;
	pos.xy = pos.xy * scaleFactor + shift;

	OUT.vpos = pos;
	OUT.txcoord.xy = IN.txcoord.xy;

	return OUT;
}

float4 PS_Draw2(VS_OUTPUT_POST IN, float2 vPos : VPOS) : COLOR
{
	float4 res;
	float2 coord=IN.txcoord.xy;

	//read sun visibility as amount of effect
	float sunmask=tex2D(SamplerMask, float2(0.5, 0.5)).x;
	sunmask=pow(sunmask, 0.8);//more contrast to clouds		//[KYO : Set more 'pizza' to clouds here]
	clip(sunmask-0.02);//early exit if too low

	float4 origcolor=tex2D(SamplerColor, coord.xy);	
	sunmask *= LightParameters.w * ELenzIntensity;
	res.xyz=origcolor.a * sunmask;

	float clipper=dot(res.xyz, 0.333);
	clip(clipper-0.0003);//skip draw if black

	res.w=1.0;
	return res;
}

technique Draw
{
	pass P0
	{
		VertexShader = compile vs_3_0 VS_Draw(-0.5, 0.14);//offset, scale
		PixelShader  = compile ps_3_0 PS_Draw();

		AlphaBlendEnable=TRUE;
		SrcBlend=ONE;
		DestBlend=ONE;

		DitherEnable=FALSE;
		ZEnable=FALSE;
		CullMode=NONE;
		ALPHATESTENABLE=FALSE;
		SEPARATEALPHABLENDENABLE=FALSE;
		StencilEnable=FALSE;
		FogEnable=FALSE;
		SRGBWRITEENABLE=FALSE;
	}

	pass P1
	{
		VertexShader = compile vs_3_0 VS_Draw(0.3, 0.3);//offset, scale
		PixelShader  = compile ps_3_0 PS_Draw();

		AlphaBlendEnable=TRUE;
		SrcBlend=ONE;
		DestBlend=ONE;

		DitherEnable=FALSE;
		ZEnable=FALSE;
		CullMode=NONE;
		ALPHATESTENABLE=FALSE;
		SEPARATEALPHABLENDENABLE=FALSE;
		StencilEnable=FALSE;
		FogEnable=FALSE;
		SRGBWRITEENABLE=FALSE;
	}

	pass P2
	{
		VertexShader = compile vs_3_0 VS_Draw(1.8, 0.6);//offset, scale
		PixelShader  = compile ps_3_0 PS_Draw();

		AlphaBlendEnable=TRUE;
		SrcBlend=ONE;
		DestBlend=ONE;

		DitherEnable=FALSE;
		ZEnable=FALSE;
		CullMode=NONE;
		ALPHATESTENABLE=FALSE;
		SEPARATEALPHABLENDENABLE=FALSE;
		StencilEnable=FALSE;
		FogEnable=FALSE;
		SRGBWRITEENABLE=FALSE;
	}
	
	pass P3
	{
		VertexShader = compile vs_3_0 VS_Draw2(1.0);//scale
		PixelShader  = compile ps_3_0 PS_Draw2();

		AlphaBlendEnable=TRUE;
		SrcBlend=ONE;
		DestBlend=ONE;

		DitherEnable=FALSE;
		ZEnable=FALSE;
		CullMode=NONE;
		ALPHATESTENABLE=FALSE;
		SEPARATEALPHABLENDENABLE=FALSE;
		StencilEnable=FALSE;
		FogEnable=FALSE;
		SRGBWRITEENABLE=FALSE;
	}
}